/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8273.RsModule;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class RsBoxConfig {
    private static String ChassisConfigComponent = "ChassisConfig";
    private static String ChassisInfoInfo = "ChassisInfo";
    private GenModel deviceModel;
    private GenModel chassisConfigModel;
    private ChassisStatus chassisStatus;
    public static final int ChassisIsPizzaSwitch = 1;
    public static final int ChassisIsOmniSwitch = 2;
    public static final int ChassisIsUnknown = 3;
    public static final int ChassisTimeout = 4;
    public static final int ChassisOtherError = 5;

    private GenModel getDeviceModel() {
        return this.deviceModel;
    }

    private GenModel getChassisConfigModel() {
        block2: {
            if (this.chassisConfigModel != null) break block2;
            try {
                this.chassisConfigModel = (GenModel)this.deviceModel.getComponent(ChassisConfigComponent);
            }
            catch (Exception exception) {
                System.out.println("Exception getting model for Chassis Config.");
                exception.printStackTrace();
            }
        }
        return this.chassisConfigModel;
    }

    public RsBoxConfig(GenModel genModel) {
        this.deviceModel = genModel;
        this.chassisStatus = null;
        this.buildBoxConfig();
    }

    public boolean is8273mod100() {
        RsModule rsModule;
        boolean bl = false;
        if (this.chassisStatus != null && this.chassisStatus.getChasType() == 5 && (rsModule = this.chassisStatus.getSlotWithNum(2)) != null && rsModule.getSlotType() == 13) {
            bl = true;
        }
        return bl;
    }

    public boolean is8273mod10u() {
        RsModule rsModule;
        boolean bl = false;
        if (this.chassisStatus != null && this.chassisStatus.getChasType() == 5 && (rsModule = this.chassisStatus.getSlotWithNum(2)) != null && rsModule.getSlotType() == 33) {
            bl = true;
        }
        return bl;
    }

    public int testForRouteSwitch() {
        int n = 3;
        try {
            ModelInfo modelInfo = this.getChassisConfigModel().getInfo(ChassisInfoInfo);
            if (modelInfo.get("ChassisInfo.ChasType") instanceof Integer) {
                int n2 = (Integer)modelInfo.get("ChassisInfo.ChasType");
                switch (n2) {
                    case 5: {
                        n = 1;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: {
                        n = 2;
                        break;
                    }
                    default: {
                        n = 3;
                        break;
                    }
                }
            }
            if (modelInfo.get("ChassisInfo.ChasType") instanceof Timeout) {
                n = 4;
            }
        }
        catch (Exception exception) {
            n = 5;
            System.out.println("Exception getting Chassis Type");
            exception.printStackTrace();
        }
        return n;
    }

    public void buildBoxConfig() {
        int n = this.testForRouteSwitch();
        if (n == 1 || n == 2) {
            this.chassisStatus = new ChassisStatus();
            this.getXylanCompaqStructure();
        }
    }

    public int getChasType() {
        if (this.chassisStatus == null) {
            return 0;
        }
        return this.chassisStatus.getChasType();
    }

    public int getNumOfSlots() {
        if (this.chassisStatus == null) {
            return 0;
        }
        return this.chassisStatus.getNumOfSlots();
    }

    public RsModule getModuleAt(int n) {
        if (this.chassisStatus == null) {
            return null;
        }
        return this.chassisStatus.getSlotAt(n);
    }

    public RsModule getModuleWithNum(int n) {
        if (this.chassisStatus == null) {
            return null;
        }
        return this.chassisStatus.getSlotWithNum(n);
    }

    public Vector getListOfModules() {
        if (this.chassisStatus == null) {
            return null;
        }
        return this.chassisStatus.getListOfSlots();
    }

    private void getXylanCompaqStructure() {
        ModelInfo modelInfo = null;
        byte[] byArray = null;
        try {
            modelInfo = this.getChassisConfigModel().getInfo(ChassisInfoInfo);
            if (modelInfo.get("ChassisInfo.ChasXylanCompaq") instanceof OctetString) {
                byArray = ((OctetString)modelInfo.get((String)"ChassisInfo.ChasXylanCompaq")).value;
                this.decodeXylanCompaq(byArray);
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception getting chasXylanCompaq");
            exception.printStackTrace();
        }
    }

    private void decodeXylanCompaq(byte[] byArray) throws RemoteException {
        if (byArray != null) {
            RsModule rsModule;
            this.chassisStatus.setChasType(byArray[0]);
            this.chassisStatus.setPowerSupply1(byArray[1]);
            this.chassisStatus.setPowerSupply2(byArray[2]);
            this.chassisStatus.setNumSubUnits(byArray[3]);
            int n = 4;
            int n2 = 1;
            while (n2 <= 9) {
                if (byArray[n] != 2 && byArray[n] != 3) {
                    this.chassisStatus.addSlot(n2, byArray[n]);
                }
                n += 4;
                ++n2;
            }
            int n3 = 1;
            while (n3 <= 16) {
                if (byArray[n] != 0) {
                    rsModule = this.chassisStatus.getSlotWithNum(byArray[n]);
                    rsModule.addSubUnit(byArray[n + 1], byArray[n + 2]);
                }
                n += 8;
                ++n3;
            }
            int n4 = 1;
            while (n4 <= 9) {
                rsModule = this.chassisStatus.getSlotWithNum(n4);
                if (rsModule == null) {
                    n += 16;
                } else {
                    int n5;
                    switch (rsModule.getSlotType()) {
                        case 13: {
                            n5 = 16;
                            break;
                        }
                        default: {
                            n5 = 8;
                        }
                    }
                    int n6 = 1;
                    while (n6 <= n5) {
                        if (byArray[n + n6 - 1] != 3) {
                            rsModule.addPort(n6, byArray[n + n6 - 1]);
                        }
                        ++n6;
                    }
                    n += 16;
                }
                ++n4;
            }
        }
    }

    final /* synthetic */ GenModel access$0() {
        return this.getDeviceModel();
    }

    private class ChassisStatus {
        private int chasType;
        private int powerSupply1;
        private int powerSupply2;
        private int numSubUnits;
        private Vector slotList = new Vector();

        ChassisStatus() {
            RsBoxConfig.this = RsBoxConfig.this;
        }

        int getChasType() {
            return this.chasType;
        }

        void setChasType(int n) {
            this.chasType = n;
        }

        int getPowerSupply1() {
            return this.powerSupply1;
        }

        void setPowerSupply1(int n) {
            this.powerSupply1 = n;
        }

        int getPowerSupply2() {
            return this.powerSupply2;
        }

        void setPowerSupply2(int n) {
            this.powerSupply2 = n;
        }

        int getNumSubUnits() {
            return this.numSubUnits;
        }

        void setNumSubUnits(int n) {
            this.numSubUnits = n;
        }

        int getNumOfSlots() {
            return this.slotList.size();
        }

        void addSlot(int n, int n2) throws RemoteException {
            RsModule rsModule = new RsModule(n, n2, RsBoxConfig.this.access$0());
            this.slotList.addElement(rsModule);
        }

        RsModule getSlotAt(int n) {
            return (RsModule)this.slotList.elementAt(n);
        }

        RsModule getSlotWithNum(int n) {
            RsModule rsModule = null;
            Enumeration enumeration = this.slotList.elements();
            while (enumeration.hasMoreElements()) {
                RsModule rsModule2 = (RsModule)enumeration.nextElement();
                if (rsModule2.getSlotNum() != n) continue;
                rsModule = rsModule2;
                break;
            }
            return rsModule;
        }

        Vector getListOfSlots() {
            return this.slotList;
        }
    }
}

